﻿using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
    public class EventRemindersDB : DBUtils
    {
        public IEnumerable<ReferralFollowUp> GetEventReminders(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_LAST_NAME,
            bool? REMINDER,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            List<ReferralFollowUp> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_GetEventReminders(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            PATIENT_LAST_NAME,
                            REMINDER,
                            SORT_COLUMN,
                            START_ROW,
                            MAX_ROWS)
                        .ToList();

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public int GetEventRemindersCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_LAST_NAME,
            bool? REMINDER)
        {
            int? objReturn = 0;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_GetEventRemindersCount(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            PATIENT_LAST_NAME,
                            REMINDER,
                            ref objReturn);

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn.HasValue ? objReturn.Value : 0;
        }
    }
}
